<?php

namespace AMLA\SqrBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ContratType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
        ->add('termeDetail')
        ->add('niuPrestataire')
        ->add('niuCommanditaire')
        ->add('nomPrestataire')
        ->add('nomCommanditaire')
        ->add('sigleStructurePrestataire')
        ->add('sigleStructureCommanditaire')
        ->add('nomSignaturePrestataire')
        ->add('nomSignatureCommanditaire')
        ->add('dureeContrat')
        ->add('offre')
        ->add('montantHtLocal')
        ->add('montantHtExterieur')
        ->add('etablissement')
        ->add('droitFixe')
        ->add('resident')
        ->add('moyenPaiement')
        ->add('banquePaiement')
        ->add('ribPaiement')
        ->add('niu')
        ->add('numeroMarche')
        ->add('idMaitreOuvrage')
        ->add('idCelluleEnregistrement')
        ->add('idOrganismeFinancement')
        ->add('dateSignature')
        ->add('dateVisa')
        ->add('nombreExemplaire')
        ->add('nombrePageExemplaire')
        ->add('nombreAnnexe')
        ->add('pourcentGarantie')
        ->add('pourcentCautionnement')
        ->add('pourcentNantissement')
        ->add('cautionSurTtc')
        ->add('garantieSurTtc')
        ->add('nantissementSurTtc')
        ->add('dossierTimbre')
        ->add('carburant')
        ->add('tvaIgnoree')
        ->add('enregistrementGratis')
        ->add('idshareApplication')
        //->add('dateCreated')
        //->add('status')
        //->add('account')
        ;
    }/**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AMLA\SqrBundle\Entity\Contrat'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'amla_sqrbundle_contrat';
    }


}
